
/* Copyright (C) 2001-2007 Monotype Imaging Inc. All rights reserved. */

/* Confidential information of Monotype Imaging Inc. */

/* fs_tablecmp.c */


#include "fs_itype.h"

#ifdef FS_ACT3

MTX_TABLE_COMPRESS *MTX_TABLE_COMPRESS_Create( _DS0_ )
{
    MTX_TABLE_COMPRESS *t;
#ifdef FS_MEM_DBG
    STATE.memdbgid = "MTX_TABLE_COMPRESS";
#endif
    t = (MTX_TABLE_COMPRESS *)FSS_malloc(_PS_ sizeof(MTX_TABLE_COMPRESS));
    if (t == 0)
        return NULL;

    t->numEntries       = 0;
    t->numSlots         = 0;
    t->rb               = NULL;
    t->numTags          = 0;
    t->tagsToCompress   = NULL;
    t->sfnt0            = NULL;
    t->sfnt1            = NULL;
    return t;
}

FS_VOID MTX_TABLE_COMPRESS_Destroy(_DS_ MTX_TABLE_COMPRESS *t)
{
    FSS_free(_PS_ (MTX_ROM_BLOCK *)(t->rb));
    FSS_free(_PS_ t);

}
static MTX_TABLE_COMPRESS *MTX_TABLE_COMPRESS_Add( _DS_ MTX_TABLE_COMPRESS *t, FS_ULONG uStart, FS_ULONG uLength,
        FS_ULONG cmpStart, FS_SHORT isCompressed)
{
    /* Make sure there's room */
    if (t->numEntries == t->numSlots)
    {
        if (!t->numSlots)                   /* First time through ...                       */
            t->numSlots = 20;               /* cough up 20 slots.                           */
        else                                /* later times through ...                      */
            t->numSlots += t->numSlots / 2; /* add half again as many as we already have    */

#ifdef FS_MEM_DBG
        STATE.memdbgid = "MTX_ROM_BLOCK";
#endif
        t->rb = (MTX_ROM_BLOCK *)FSS_realloc( _PS_ (FS_VOID *)t->rb, t->numSlots * sizeof(MTX_ROM_BLOCK));
        if (t->rb == 0)
            return NULL;
    }
    t->rb[t->numEntries].start          = uStart;
    t->rb[t->numEntries].length         = uLength;
    t->rb[t->numEntries].cmpStart       = cmpStart;
    t->rb[t->numEntries].isCompressed   = isCompressed;
    t->numEntries++;
    return t;
}


MTX_RA_TT_Decomp *MTX_RA_TT_ReadRom(_DS_ MTX_RA_TT_Decomp *t, FS_BYTE *data )
{
    FS_SHORT i;
    FS_ULONG datastart;
    FS_ULONG length;
    FS_ULONG cmpStart;
    FS_SHORT isCompressed;
    MTX_TABLE_COMPRESS *tc;

    tc = t->tc;

    t->headerLength     = READWORD_INC(&data);
    t->cmpSize          = READLONG_INC(&data);
    t->uncmpSize        = READLONG_INC(&data);
    t->glyf_OffsetStart = READLONG_INC(&data);
    t->glyf_OffsetEnd   = READLONG_INC(&data);
    i                   = READWORD_INC(&data);
    while (i--)
    {
        datastart    = READLONG_INC(&data);
        length       = READLONG_INC(&data);
        cmpStart     = READLONG_INC(&data);
        isCompressed = READWORD_INC(&data);
        if (!MTX_TABLE_COMPRESS_Add( _PS_ tc, datastart, length, cmpStart, isCompressed))
            return NULL;
    }
    return t;
}

#endif /* FS_ACT3 */
